/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.fabric.ui.containers;

import ca.landonjw.gooeylibs2.api.button.Button;
import ca.landonjw.gooeylibs2.api.page.GooeyPage;
import ca.landonjw.gooeylibs2.api.template.Template;
import ca.landonjw.gooeylibs2.api.template.types.ChestTemplate;
import java.util.Optional;
import net.impactdev.impactor.api.platform.players.PlatformPlayer;
import net.impactdev.impactor.api.ui.containers.Icon;
import net.impactdev.impactor.api.ui.containers.views.ChestView;
import net.impactdev.impactor.fabric.ui.gooey.GooeyIcon;
import net.impactdev.impactor.fabric.ui.gooey.GooeyPageOpenCloser;
import net.impactdev.impactor.minecraft.api.items.AdventureTranslator;
import net.impactdev.impactor.minecraft.api.items.ServerProvider;
import net.impactdev.impactor.minecraft.ui.containers.views.chests.ImpactorChestView;
import org.jetbrains.annotations.Nullable;

public final class FabricChestView
extends ImpactorChestView
implements GooeyPageOpenCloser {
    private final ChestTemplate template;
    private final GooeyPage delegate;

    private FabricChestView(ImpactorChestView.ImpactorChestViewBuilder builder) {
        super(builder);
        ChestTemplate.Builder template = ChestTemplate.builder((int)this.rows());
        this.layout().elements().forEach((slot, icon) -> template.set(slot.intValue(), (Button)new GooeyIcon((Icon)icon)));
        AdventureTranslator.Server translator = AdventureTranslator.Server.get(ServerProvider.server());
        this.template = template.build();
        this.delegate = GooeyPage.builder().template((Template)this.template).title(translator.asNative(this.title())).build();
    }

    @Override
    public void set(@Nullable Icon icon, int slot) {
        this.template.set(slot, (Button)Optional.ofNullable(icon).map(GooeyIcon::new).orElse(null));
    }

    @Override
    public void open(PlatformPlayer viewer) {
        super.open(viewer);
        this.openPage(this.delegate, viewer);
    }

    @Override
    public void close(PlatformPlayer viewer) {
        super.close(viewer);
        this.closePage(viewer);
    }

    public static final class FabricImpactorChestViewBuilder
    extends ImpactorChestView.ImpactorChestViewBuilder {
        @Override
        public ChestView build() {
            return new FabricChestView(this);
        }
    }
}

